/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.DynamicModifier;

public abstract class AbstractModifierProvider
extends GenericDataProvider {
    private final Map<ModifierId, Result> allModifiers = new HashMap<ModifierId, Result>();

    public AbstractModifierProvider(DataGenerator generator) {
        super(generator, PackType.SERVER_DATA, "tinkering/modifiers", ModifierManager.GSON);
    }

    protected abstract void addModifiers();

    protected void addModifier(ModifierId id, @Nullable ICondition condition, @Nullable Modifier result, JsonRedirect ... redirects) {
        Result previous;
        if (result == null && redirects.length == 0) {
            throw new IllegalArgumentException("Must hae either a modifier or a redirect");
        }
        if (redirects.length == 0) {
            redirects = null;
        }
        if ((previous = this.allModifiers.putIfAbsent(id, new Result(result, condition, redirects))) != null) {
            throw new IllegalArgumentException("Duplicate modifier " + id);
        }
    }

    protected void addModifier(ModifierId id, @Nullable Modifier result, JsonRedirect ... redirects) {
        this.addModifier(id, null, result, redirects);
    }

    protected void addModifier(DynamicModifier<?> id, @Nullable ICondition condition, @Nullable Modifier result, JsonRedirect ... redirects) {
        this.addModifier(id.getId(), condition, result, redirects);
    }

    protected void addModifier(DynamicModifier<?> id, @Nullable Modifier result, JsonRedirect ... redirects) {
        this.addModifier(id, null, result, redirects);
    }

    protected void addRedirect(ModifierId id, JsonRedirect ... redirects) {
        this.addModifier(id, (ICondition)null, (Modifier)null, redirects);
    }

    protected JsonRedirect conditionalRedirect(ModifierId id, @Nullable ICondition condition) {
        return new JsonRedirect(id, condition);
    }

    protected JsonRedirect redirect(ModifierId id) {
        return this.conditionalRedirect(id, null);
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.addModifiers();
        this.allModifiers.forEach((id, data) -> this.saveThing(cache, (ResourceLocation)id, AbstractModifierProvider.convert(data)));
    }

    private static JsonObject convert(Result result) {
        JsonObject json = result.modifier != null ? ModifierManager.MODIFIER_LOADERS.serialize((GenericLoaderRegistry.IHaveLoader)result.modifier).getAsJsonObject() : new JsonObject();
        if (result.redirects != null) {
            JsonArray array = new JsonArray();
            for (JsonRedirect redirect : result.redirects) {
                array.add((JsonElement)redirect.toJson());
            }
            json.add("redirects", (JsonElement)array);
        }
        if (result.condition != null) {
            json.add("condition", (JsonElement)CraftingHelper.serialize((ICondition)result.condition));
        }
        return json;
    }

    private record Result(@Nullable Modifier modifier, @Nullable ICondition condition, JsonRedirect[] redirects) {
    }
}

